
package com.limegroup.gnutella.bootstrap;

import java.text.ParseException;

/**
 * The list of default GWebCache urls, used the first time LimeWire starts, or
 * if the gnutella.net file is accidentally deleted.  Entries in the list will
 * eventually be replaced by URLs discovered during urlfile=1 requests.  Order
 * does not matter.
 *
 * THIS FILE IS AUTOMATICALLY GENERATED FROM MAKE_DEFAULT.PY.
 */
public class DefaultBootstrapServers {
    /**
     * Adds all the default servers to bman. 
     */
    public static void addDefaults(BootstrapServerManager bman) {
        for (int i=0; i<urls.length; i++) {
            try {
                BootstrapServer server=new BootstrapServer(urls[i]);
                bman.addBootstrapServer(server);
            } catch (ParseException ignore) {
            }                
        }
    }

    //These should NOT be URL encoded.
    static String[] urls=new String[] {
        "http://97k.ath.cx/mwebcache/mcache.php",
        "http://gwc.downloadmusicinc.com/gcache.cgi",
        "http://gwc.dietpac.com:8080/",
        "http://gwc.glucolene.com:8080/",
        "http://jercos.dyndns.org/perlgcache.cgi",
        "http://mute.frac.dk/mcache.php",
        "http://www.rent-a-nerd.dk/mute/mcache.php",
        "http://mutecache.ath.cx/mcache.php",
        "http://mcache.guenever.net/mcache.php",
        "http://mute.filesharingdownloads.be/mcache.php"
    };
}
